angular.module("colorpicker.module",[]).factory("Helper",(function(){"use strict";return{closestSlider:function(e){return(e.matches||e.webkitMatchesSelector||e.mozMatchesSelector||e.msMatchesSelector).bind(e)("I")?e.parentNode:e},getOffset:function(e,o){for(var t=0,n=0,r=e.getBoundingClientRect();e&&!isNaN(e.offsetLeft)&&!isNaN(e.offsetTop);)o||"BODY"!==e.tagName?(t+=e.scrollLeft,n+=e.scrollTop):(t+=document.documentElement.scrollLeft||e.scrollLeft,n+=document.documentElement.scrollTop||e.scrollTop),e=e.offsetParent;return{top:r.top+window.pageYOffset,left:r.left+window.pageXOffset,scrollX:t,scrollY:n}},stringParsers:[{re:/rgba?\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)/,parse:function(e){return[e[1],e[2],e[3],e[4]]}},{re:/rgba?\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)/,parse:function(e){return[2.55*e[1],2.55*e[2],2.55*e[3],e[4]]}},{re:/#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/,parse:function(e){return[parseInt(e[1],16),parseInt(e[2],16),parseInt(e[3],16)]}},{re:/#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/,parse:function(e){return[parseInt(e[1]+e[1],16),parseInt(e[2]+e[2],16),parseInt(e[3]+e[3],16)]}}]}})).factory("Color",["Helper",function(e){"use strict";return{value:{h:1,s:1,b:1,a:1},rgb:function(){var e=this.toRGB();return"rgb("+e.r+","+e.g+","+e.b+")"},rgba:function(){var e=this.toRGB();return"rgba("+e.r+","+e.g+","+e.b+","+e.a+")"},hex:function(){return this.toHex()},RGBtoHSB:function(e,o,t,n){var r,i;return e/=255,o/=255,t/=255,{h:((0===(i=(r=Math.max(e,o,t))-Math.min(e,o,t))?null:r===e?(o-t)/i:r===o?(t-e)/i+2:(e-o)/i+4)+360)%6*60/360||1,s:0===i?0:i/r,b:r,a:n||1}},setColor:function(o){for(var t in o=o?o.toLowerCase():o,e.stringParsers)if(e.stringParsers.hasOwnProperty(t)){var n=e.stringParsers[t],r=n.re.exec(o),i=r&&n.parse(r);if(i)return this.value=this.RGBtoHSB.apply(null,i),!1}},setHue:function(e){this.value.h=1-e},setSaturation:function(e){this.value.s=e},setLightness:function(e){this.value.b=1-e},setAlpha:function(e){this.value.a=parseInt(100*(1-e),10)/100},toRGB:function(e,o,t,n){var r,i,l,s,c;return e||(e=this.value.h,o=this.value.s,t=this.value.b),e=(e*=360)%360/60,r=i=l=t-(c=t*o),r+=[c,s=c*(1-Math.abs(e%2-1)),0,0,s,c][e=~~e],i+=[s,c,c,s,0,0][e],l+=[0,0,s,c,c,s][e],{r:Math.round(255*r),g:Math.round(255*i),b:Math.round(255*l),a:n||this.value.a}},toHex:function(e,o,t,n){var r=this.toRGB(e,o,t,n);return"#"+(1<<24|parseInt(r.r,10)<<16|parseInt(r.g,10)<<8|parseInt(r.b,10)).toString(16).substr(1)}}}]).factory("Slider",["Helper",function(e){"use strict";var o={maxLeft:0,maxTop:0,callLeft:null,callTop:null,knob:{top:0,left:0}},t={};return{getSlider:function(){return o},getLeftPosition:function(e){return Math.max(0,Math.min(o.maxLeft,o.left+((e.pageX||t.left)-t.left)))},getTopPosition:function(e){return Math.max(0,Math.min(o.maxTop,o.top+((e.pageY||t.top)-t.top)))},setSlider:function(n,r){var i=e.closestSlider(n.target),l=e.getOffset(i,r),s=i.getBoundingClientRect(),c=n.clientX-s.left,a=n.clientY-s.top;o.knob=i.children[0].style,o.left=n.pageX-l.left-window.pageXOffset+l.scrollX,o.top=n.pageY-l.top-window.pageYOffset+l.scrollY,t={left:n.pageX-(c-o.left),top:n.pageY-(a-o.top)}},setSaturation:function(e,t){o={maxLeft:100,maxTop:100,callLeft:"setSaturation",callTop:"setLightness"},this.setSlider(e,t)},setHue:function(e,t){o={maxLeft:0,maxTop:100,callLeft:!1,callTop:"setHue"},this.setSlider(e,t)},setAlpha:function(e,t){o={maxLeft:0,maxTop:100,callLeft:!1,callTop:"setAlpha"},this.setSlider(e,t)},setKnob:function(e,t){o.knob.top=e+"px",o.knob.left=t+"px"}}}]).directive("colorpicker",["$document","$compile","Color","Slider","Helper",function(e,o,t,n,r){"use strict";return{require:"?ngModel",restrict:"A",link:function(i,l,s,c){var a,p=s.colorpicker?s.colorpicker:"hex",u=angular.isDefined(s.colorpickerPosition)?s.colorpickerPosition:"bottom",f=!!angular.isDefined(s.colorpickerInline)&&s.colorpickerInline,d=!!angular.isDefined(s.colorpickerFixedPosition)&&s.colorpickerFixedPosition,m=angular.isDefined(s.colorpickerParent)?l.parent():angular.element(document.body),h=!!angular.isDefined(s.colorpickerWithInput)&&s.colorpickerWithInput,v='<div class="colorpicker dropdown"><div class="dropdown-menu"><colorpicker-saturation><i></i></colorpicker-saturation><colorpicker-hue><i></i></colorpicker-hue><colorpicker-alpha><i></i></colorpicker-alpha><colorpicker-preview></colorpicker-preview>'+(h?'<input type="text" name="colorpicker-input" spellcheck="false">':"")+(f?"":'<button type="button" class="close close-colorpicker">&times;</button>')+"</div></div>",k=angular.element(v),g=t,b=k.find("colorpicker-hue"),w=k.find("colorpicker-saturation"),x=k.find("colorpicker-preview"),C=k.find("i");if(o(k)(i),h){var T=k.find("input");T.on("mousedown",(function(e){e.stopPropagation()})).on("keyup",(function(){var e=this.value;l.val(e),c&&c.$modelValue!==e&&(i.$apply(c.$setViewValue(e)),update(!0))}))}function bindMouseEvents(){e.on("mousemove",mousemove),e.on("mouseup",mouseup)}function previewColor(){try{x.css("backgroundColor",g[p]())}catch(e){x.css("backgroundColor",g.toHex())}w.css("backgroundColor",g.toHex(g.value.h,1,1,1)),"rgba"===p&&(a.css.backgroundColor=g.toHex())}function mousemove(e){var o=n.getLeftPosition(e),t=n.getTopPosition(e),r=n.getSlider();n.setKnob(t,o),r.callLeft&&g[r.callLeft].call(g,o/100),r.callTop&&g[r.callTop].call(g,t/100),previewColor();var s=g[p]();return l.val(s),c&&i.$apply(c.$setViewValue(s)),h&&T.val(s),!1}function mouseup(){emitEvent("colorpicker-selected"),e.off("mousemove",mousemove),e.off("mouseup",mouseup)}function update(e){g.setColor(l.val()),h&&!e&&T.val(l.val()),C.eq(0).css({left:100*g.value.s+"px",top:100-100*g.value.b+"px"}),C.eq(1).css("top",100*(1-g.value.h)+"px"),C.eq(2).css("top",100*(1-g.value.a)+"px"),previewColor()}function documentMousedownHandler(){hideColorpickerTemplate()}function showColorpickerTemplate(){k.hasClass("colorpicker-visible")||(update(),k.addClass("colorpicker-visible").css(function getColorpickerTemplatePosition(){var e,o=r.getOffset(l[0]);return angular.isDefined(s.colorpickerParent)&&(o.left=0,o.top=0),"top"===u?e={top:o.top-147,left:o.left}:"right"===u?e={top:o.top,left:o.left+126}:"bottom"===u?e={top:o.top+l[0].offsetHeight+2,left:o.left}:"left"===u&&(e={top:o.top,left:o.left-150}),{top:e.top+"px",left:e.left+"px"}}()),emitEvent("colorpicker-shown"),!1===f&&e.on("mousedown",documentMousedownHandler),s.colorpickerIsOpen&&(i[s.colorpickerIsOpen]=!0,i.$$phase||i.$digest()))}function emitEvent(e){c&&i.$emit(e,{name:s.ngModel,value:c.$modelValue})}function hideColorpickerTemplate(){k.hasClass("colorpicker-visible")&&(k.removeClass("colorpicker-visible"),emitEvent("colorpicker-closed"),e.off("mousedown",documentMousedownHandler),s.colorpickerIsOpen&&(i[s.colorpickerIsOpen]=!1,i.$$phase||i.$digest()))}"rgba"===p&&(k.addClass("alpha"),(a=k.find("colorpicker-alpha")).on("click",(function(e){n.setAlpha(e,d),mousemove(e)})).on("mousedown",(function(e){n.setAlpha(e,d),bindMouseEvents()})).on("mouseup",(function(e){emitEvent("colorpicker-selected-alpha")}))),b.on("click",(function(e){n.setHue(e,d),mousemove(e)})).on("mousedown",(function(e){n.setHue(e,d),bindMouseEvents()})).on("mouseup",(function(e){emitEvent("colorpicker-selected-hue")})),w.on("click",(function(e){n.setSaturation(e,d),mousemove(e),angular.isDefined(s.colorpickerCloseOnSelect)&&hideColorpickerTemplate()})).on("mousedown",(function(e){n.setSaturation(e,d),bindMouseEvents()})).on("mouseup",(function(e){emitEvent("colorpicker-selected-saturation")})),d&&k.addClass("colorpicker-fixed-position"),k.addClass("colorpicker-position-"+u),"true"===f&&k.addClass("colorpicker-inline"),m.append(k),c&&(c.$render=function(){l.val(c.$viewValue),update()}),l.on("blur keyup change",(function(){update()})),l.on("$destroy",(function(){k.remove()})),!1===f?l.on("click",showColorpickerTemplate):showColorpickerTemplate(),k.on("mousedown",(function(e){e.stopPropagation(),e.preventDefault()})),k.find("button").on("click",(function(){hideColorpickerTemplate()})),s.colorpickerIsOpen&&i.$watch(s.colorpickerIsOpen,(function(e){!0===e?showColorpickerTemplate():!1===e&&hideColorpickerTemplate()}))}}}]);