angular.module("datetime",[]),angular.module("datetime").factory("datetime",["$locale",function(e){var t=e.DATETIME_FORMATS,n=/yyyy|yy|y|M{1,4}|dd?|EEEE?|HH?|hh?|mm?|ss?|([.,])sss|a|Z|ww|w|'(([^']+|'')*)'/g,a={y:{minLength:1,maxLength:4,min:1,max:9999,name:"year",type:"number"},yy:{minLength:2,maxLength:2,min:1,max:99,name:"year",type:"number"},yyyy:{minLength:4,maxLength:4,min:1,max:9999,name:"year",type:"number"},MMMM:{name:"month",type:"select",select:t.MONTH},MMM:{name:"month",type:"select",select:t.SHORTMONTH},MM:{minLength:2,maxLength:2,min:1,max:12,name:"month",type:"number"},M:{minLength:1,maxLength:2,min:1,max:12,name:"month",type:"number"},dd:{minLength:2,maxLength:2,min:1,max:31,name:"date",type:"number"},d:{minLength:1,maxLength:2,min:1,max:31,name:"date",type:"number"},EEEE:{name:"day",type:"select",select:fixDay(t.DAY)},EEE:{name:"day",type:"select",select:fixDay(t.SHORTDAY)},HH:{minLength:2,maxLength:2,min:0,max:23,name:"hour",type:"number"},H:{minLength:1,maxLength:2,min:0,max:23,name:"hour",type:"number"},hh:{minLength:2,maxLength:2,min:1,max:12,name:"hour12",type:"number"},h:{minLength:1,maxLength:2,min:1,max:12,name:"hour12",type:"number"},mm:{minLength:2,maxLength:2,min:0,max:59,name:"minute",type:"number"},m:{minLength:1,maxLength:2,min:0,max:59,name:"minute",type:"number"},ss:{minLength:2,maxLength:2,min:0,max:59,name:"second",type:"number"},s:{minLength:1,maxLength:2,min:0,max:59,name:"second",type:"number"},milliPrefix:{name:"milliPrefix",type:"regex",regex:/[,.]/},sss:{minLength:3,maxLength:3,min:0,max:999,name:"millisecond",type:"number"},a:{name:"ampm",type:"select",select:t.AMPMS},ww:{minLength:2,maxLength:2,min:0,max:53,name:"week",type:"number"},w:{minLength:1,maxLength:2,min:0,max:53,name:"week",type:"number"},Z:{name:"timezone",type:"regex",regex:/[+-]\d{4}/},string:{name:"string",type:"static"}};function fixDay(e){var t,n=[];for(t=1;t<e.length;t++)n.push(e[t]);return n.push(e[0]),n}function createNode(e,t){return{token:a[e],value:t,viewValue:t||"",offset:0}}function getMatch(e,t,n){for(var a=0,r=e.toUpperCase(),s=n.toUpperCase();r[t+a]&&r[t+a]==s[a];)a++;return e.substr(t,a)}function getWeek(e){var t=new Date(e.getFullYear(),0,1),n=new Date(t.getTime());n.getDay()>4?n.setDate(n.getDate()+(1-n.getDay())+7):n.setDate(n.getDate()+(1-n.getDay()));var a=e.getTime()-n.getTime();return Math.floor(a/6048e5)}function num2str(e,t,n){var a;if((e=""+e).length>n)e=e.substr(e.length-n);else if(e.length<t)for(a=e.length;a<t;a++)e="0"+e;return e}function setText(e,t,n){switch(n.name){case"year":e.value=t.getFullYear();break;case"month":e.value=t.getMonth()+1;break;case"date":e.value=t.getDate();break;case"day":e.value=t.getDay()||7;break;case"hour":e.value=t.getHours();break;case"hour12":e.value=t.getHours()%12||12;break;case"ampm":e.value=t.getHours()<12?1:2;break;case"minute":e.value=t.getMinutes();break;case"second":e.value=t.getSeconds();break;case"millisecond":e.value=t.getMilliseconds();break;case"week":e.value=getWeek(t);break;case"timezone":e.value=(t.getTimezoneOffset()>0?"-":"+")+num2str(Math.abs(t.getTimezoneOffset()/60),2,2)+"00"}switch(e.value<0&&(e.value=0),n.type){case"number":e.viewValue=num2str(e.value,n.minLength,n.maxLength);break;case"select":e.viewValue=n.select[e.value-1];break;default:e.viewValue=e.value+""}}function setDate(e,t,n){switch(n.name){case"year":e.setFullYear(t);break;case"month":e.setMonth(t-1);break;case"date":e.setDate(t);break;case"day":!function setDay(e,t){var n=e.getMonth(),a=t-(e.getDay()||7);e.setDate(e.getDate()+a),e.getMonth()!=n&&(a>0?e.setDate(e.getDate()-7):e.setDate(e.getDate()+7))}(e,t);break;case"hour":e.setHours(t);break;case"hour12":!function setHour12(e,t){t%=12,e.getHours()>=12&&(t+=12),e.setHours(t)}(e,t);break;case"ampm":!function setAmpm(e,t){var n=e.getHours();n<12==t>1&&e.setHours((n+12)%24)}(e,t);break;case"minute":e.setMinutes(t);break;case"second":e.setSeconds(t);break;case"millisecond":e.setMilliseconds(t);break;case"week":e.setDate(e.getDate()+7*(t-getWeek(e)))}e.getFullYear()<0&&e.setFullYear(0)}function parseNode(e,t,n){var a,r,s,o,i=e;switch(i.token.type){case"static":if(t.lastIndexOf(i.value,n)!=n)throw{code:"TEXT_MISMATCH",message:"Pattern value mismatch",text:t,node:i,pos:n};break;case"number":if(null==(s=function getInteger(e,t){var n=(e=e.substring(t)).match(/^\d+/);return n&&n[0]}(t,n)))throw{code:"NUMBER_MISMATCH",message:"Invalid number",text:t,node:i,pos:n};if(s.length<i.token.minLength)throw{code:"NUMBER_TOOSHORT",message:"The length of number is too short",text:t,node:i,pos:n,match:s};s.length>i.token.maxLength&&(s=s.substr(0,i.token.maxLength)),i.value=+s,i.viewValue=s;break;case"select":for(r="",o=0;o<i.token.select.length;o++)(a=getMatch(t,n,i.token.select[o]))&&a.length>r.length&&(s=o,r=a);if(!r)throw{code:"SELECT_MISMATCH",message:"Invalid select",text:t,node:i,pos:n};if(r!=i.token.select[s])throw{code:"SELECT_INCOMPLETE",message:"Incomplete select",text:t,node:i,pos:n,match:r,selected:i.token.select[s]};i.value=s+1,i.viewValue=r;break;case"regex":if(!(a=i.regex.exec(t.substr(n)))||0!=a.index)throw{code:"REGEX_MISMATCH",message:"Regex doesn't match",text:t,node:i,pos:n};i.value=a[0],i.viewValue=a[0]}}return function createParser(e){var a=function createNodes(e){for(var t,a,r=[],s=0;t=n.exec(e);)t.index>s&&(r.push(createNode("string",e.substring(s,t.index))),s=t.index),t.index==s&&(t[1]?(r.push(createNode("string",t[1])),r.push(createNode("sss"))):t[2]?r.push(createNode("string",t[2].replace("''","'"))):r.push(createNode(t[0])),s=n.lastIndex);for(s<e.length&&r.push(createNode("string",e.substring(s))),a=0;a<r.length;a++)r[a].next=r[a+1]||null,r[a].prev=r[a-1]||null,r[a].id=a;return r}(e=function getFormat(e){return t[e]||e}(e)),r={parse:function(e){var t,n=r.date,a=new Date(n.getTime()),s=r.getText();if(!e)throw{code:"EMPTY",message:"The input is empty",oldText:s};try{if(function parseLoop(e,t,n){var a,r,s,o,i;for(r=0,o=new Date(n.getTime()),a=0;a<e.length;a++)try{parseNode(e[a],t,r),r+=e[a].viewValue.length,setDate(i=new Date(o.getTime()),e[a].value,e[a].token),i.getTime()!=o.getTime()&&setDate(n,e[a].value,e[a].token)}catch(e){if("NUMBER_TOOSHORT"!=e.code)throw e;s=e,r+=e.match.length}if(t.length>r)throw{code:"TEXT_TOOLONG",message:"Text is too long",text:t,pos:r};if(s)throw s}(r.nodes,e,a),r.setDate(a),e!=(t=r.getText()))throw{code:"INCONSISTENT_INPUT",message:"Successfully parsed but the output text doesn't match the input",text:e,oldText:s,properText:t}}catch(e){throw r.setDate(n),e}return r},parseNode:function(e,t){var n=new Date(r.date.getTime());try{parseNode(e,t,0)}catch(e){throw r.setDate(r.date),e}return setDate(n,e.value,e.token),r.setDate(n),r},setDate:function(e){var t,n;for(r.date=e,t=0;t<r.nodes.length;t++)setText(n=r.nodes[t],e,n.token);return function calcOffset(e){var t,n=0;for(t=0;t<e.length;t++)e[t].offset=n,n+=e[t].viewValue.length}(r.nodes),r},getDate:function(){return r.date},getText:function(){var e,t="";for(e=0;e<r.nodes.length;e++)t+=r.nodes[e].viewValue;return t},date:null,format:e,nodes:a,error:null};return r.setDate(new Date),r}}]),angular.module("datetime").directive("datetime",["datetime","$log","$document",function(e,t,n){var a=n[0];function getInputSelection(e){return null!=(e=e[0]).selectionStart&&null!=e.selectionEnd?{start:e.selectionStart,end:e.selectionEnd}:a.selection?function getInputSelectionIE(e){var t=a.selection.createRange().getBookmark(),n=e.createTextRange(),r=n.duplicate();n.moveToBookmark(t),r.setEndPoint("EndToStart",n);var s=r.text.length;return{start:s,end:s+n.text.length}}(e):void 0}function getInitialNode(e){return getNode(e[0])}function getNode(e,t){for(t||(t="next");e&&("static"==e.token.type||"regex"==e.token.type);)e=e[t];return e}function selectRange(e,t,n){e.node&&(t&&(e.start=0,e.end="end",e.node=n?function getLastNode(e,t){var n;do{n=e,e=getNode(e[t],t)}while(e);return n}(e.node,t):getNode(e.node[t],t)||e.node),function setInputSelection(e,t){(e=e[0]).setSelectionRange?e.setSelectionRange(t.start,t.end):e.createTextRange&&function setInputSelectionIE(e,t){var n=e.createTextRange();n.moveStart("character",t.start),n.collapse(),n.moveEnd("character",t.end-t.start),n.select()}(e,t)}(e.element,{start:e.start+e.node.offset,end:"end"==e.end?e.node.offset+e.node.viewValue.length:e.end+e.node.offset}))}function getRange(e,t,n){var a,r,s=getInputSelection(e);for(a=0;a<t.length;a++)if(!r&&t[a].offset+t[a].viewValue.length>=s.start||a==t.length-1){r={element:e,node:t[a],start:s.start-t[a].offset,end:s.start-t[a].offset};break}return n&&r.node.next==n&&r.start+r.node.offset==r.node.next.offset&&(r.node=r.node.next,r.start=r.end=0),r}return{restrict:"A",require:"?ngModel",link:function linkFunc(n,r,s,o){var i,d=e(s.datetime),u=s.datetimeModel&&e(s.datetimeModel),l={element:r,node:getInitialNode(d.nodes),start:0,end:"end"},c={element:r,node:null,start:0,end:0},validMin=function(e){return o.$isEmpty(e)||angular.isUndefined(s.min)||e>=new Date(s.min)},validMax=function(e){return o.$isEmpty(e)||angular.isUndefined(s.max)||e<=new Date(s.max)};function validMinMax(e){return o.$validate?o.$validate():(o.$setValidity("min",validMin(e)),o.$setValidity("max",validMax(e))),!o.$error.min&&!o.$error.max}function addNodeValue(e,t){var a,r;(function addDate(e,t,n){switch(t.name){case"year":e.setFullYear(e.getFullYear()+n);break;case"month":e.setMonth(e.getMonth()+n);break;case"date":case"day":e.setDate(e.getDate()+n);break;case"hour":case"hour12":e.setHours(e.getHours()+n);break;case"ampm":e.setHours(e.getHours()+12*n);break;case"minute":e.setMinutes(e.getMinutes()+n);break;case"second":e.setSeconds(e.getSeconds()+n);break;case"millisecond":e.setMilliseconds(e.getMilliseconds()+n);break;case"week":e.setDate(e.getDate()+7*n)}})(a=new Date(d.date.getTime()),e.token,t),d.setDate(a),r=d.getText(),o.$setViewValue(r),l.start=0,l.end="end",o.$render(),n.$apply()}o.$validators&&(o.$validators.min=validMin,o.$validators.max=validMax),s.$observe("min",(function(){validMinMax(d.getDate())})),s.$observe("max",(function(){validMinMax(d.getDate())})),o.$render=function(){r.val(o.$viewValue||""),a.activeElement==r[0]&&selectRange(l)},o.$parsers.push((function(e){if(!e&&angular.isUndefined(s.required))return l.node=getInitialNode(d.nodes),l.start=0,l.end="end",o.$setValidity("datetime",!0),null;try{d.parse(e)}catch(a){return t.error(a),o.$setValidity("datetime",!1),void("NUMBER_TOOSHORT"==a.code?(c.node=a.node,c.start=0,c.end=a.match.length):("SELECT_INCOMPLETE"==a.code?(d.parseNode(l.node,a.selected),e=d.getText(),l.start=a.match.length,l.end="end"):"INCONSISTENT_INPUT"==a.code?(e=a.properText,l.start++,l.end=l.start):(e=d.getText(),l.start=0,l.end="end"),n.$evalAsync((function(){if(e==o.$viewValue)throw"angular-datetime crashed!";o.$setViewValue(e),o.$render()}))))}return o.$setValidity("datetime",!0),o.$validate||validMinMax(d.getDate())?u?u.setDate(d.getDate()).getText():new Date(d.getDate().getTime()):void 0})),o.$formatters.push((function(e){return e?(o.$setValidity("datetime",!0),u&&(e=u.parse(e).getDate()),d.setDate(e).getText()):(o.$setValidity("datetime",angular.isUndefined(s.required)),"")})),r.on("focus keydown keypress mousedown click",(function(e){switch(e.type){case"mousedown":i=!0;break;case"focus":e.preventDefault(),o.$viewValue||(o.$setViewValue(d.getText()),o.$render(),n.$apply()),i||setTimeout((function(){o.$error.datetime?selectRange(c):selectRange(l)}));break;case"keydown":switch(e.keyCode){case 37:e.preventDefault(),o.$error.datetime?selectRange(c):selectRange(l,"prev");break;case 39:e.preventDefault(),o.$error.datetime?selectRange(c):selectRange(l,"next");break;case 38:e.preventDefault(),addNodeValue(l.node,1);break;case 40:e.preventDefault(),addNodeValue(l.node,-1);break;case 36:e.preventDefault(),o.$error.datetime?selectRange(c):selectRange(l,"prev",!0);break;case 35:e.preventDefault(),o.$error.datetime?selectRange(c):selectRange(l,"next",!0)}break;case"click":e.preventDefault(),i=!1,o.$error.datetime?selectRange(c):selectRange(l=function createRange(e,t){var n,a,r;return function isStatic(e){return"static"==e.token.type||"regex"==e.token.type}((r=getRange(e,t)).node)&&(a=getNode(r.node,"next"),n=getNode(r.node,"prev"),a||n?r.node=a&&n?function closerNode(e,t,n){var a=e.node.offset+e.start;return t.offset-a<=a-(n.offset+n.viewValue.length)?t:n}(r,a,n):a||n:(r.node=t[0],r.end=0)),r.start=0,r.end="end",r}(r,d.nodes));break;case"keypress":(function isPrintableKey(e){var t=e.charCode||e.keyCode;return t>=48&&t<=57||t>=65&&t<=90||t>=97&&t<=122})(e)&&setTimeout((function(){(function isRangeAtEnd(e){var t,n;return!!function isRangeCollapse(e){return e.start==e.end||e.start==e.node.viewValue.length&&"end"==e.end}(e)&&(t=e.node.token.maxLength,n=e.node.viewValue.length,!(t&&n<t)&&e.start==n)})(l=getRange(r,d.nodes,l.node))&&(l.node=getNode(l.node.next)||l.node,l.start=0,l.end="end",selectRange(l))}))}}))}}}]);