<!-- Overview Mode -->
<div ng-if="mode === 'overview'">
	<div class="modal-header">
		<div class="close" ng-click="close()">×</div>
		<div class="tcenter">
			<h4 class="tcenter">Paketverwaltung</h4>
			<p>Verwalte Dropper und deine Drops</p>
		</div>
		<div class="btn-group" ng-if="overviewMode !== 'forcedUpgrades'">
			<div class="btn btn-small" ng-click="setOverviewMode('upgrades')" ng-class="{'active': overviewMode == 'upgrades'}">Updates <span>({{utils.countObject(packageManager.getUpgradeable())}})</span></div>
			<div class="btn btn-small" ng-click="setOverviewMode('store')" ng-class="{'active': overviewMode == 'store'}">Store <span>({{utils.countObject(packageManager.getInstallable())}})</span></div>
			<div class="btn btn-small" ng-click="setOverviewMode('installed')" ng-class="{'active': overviewMode == 'installed'}">Installiert <span>({{utils.countObject(core.templates)}})</span></div>
			<div class="btn btn-small" ng-click="setOverviewMode('holdback')" ng-class="{'active': overviewMode == 'holdback'}" ng-if="utils.countObject(packageManager.getHoldback()) > 0">Nicht verfügbar <span>({{utils.countObject(packageManager.getHoldback())}})</span></div>
		</div>

		<!-- search installable packages -->
		<div ng-if="
			overviewMode == 'store' && utils.countObject(packageManager.getInstallable()) > 5 || 
			overviewMode == 'upgrades' && utils.countObject(packageManager.getUpgradeable()) > 5 || 
			overviewMode == 'installed' && utils.countObject(core.templates) > 5"
		>
			<input class="search p100" type="text" placeholder="Suchen" ng-model="search.filter" style="width: auto">
		</div>

	</div>
	<div class="modal-body no-padding">
		<!-- Show Upgrades -->
		<div ng-if="overviewMode == 'upgrades'">
			<div ng-if="packageManager.hasUpgradeablePackages()">
				<div ng-repeat="(type, typeName) in packageTypes" ng-show="utils.countObject(packageManager.getUpgradeable(type)) > 0">
					<div class="clearfix p-1">
						<h4 class="tleft">{{typeName}}</h4>
					</div>
					<hr class="m-0">
					<div class="drop-list list-style">
						<div class="drop" ng-repeat="(id, package) in packageManager.getUpgradeable(type) | filterObj:'meta.name':search.filter" ng-click="select(package, 'upgrade')">
							<span class="drop-image" style="background-image:url({{package.meta.icon}})"></span>
							<div class="name">{{package.meta.name}}
								<span class="badge badge-info pull-right">{{packageManager.getInstalledVersion(id)}} &raquo; {{package.candidate.version}}</span>
								<span class="badge pull-right m-05-right" ng-if="package.candidate.force">Pflichtupdate</span>
							</div>
							<div class="desc">{{package.meta.description}}</div>
							<div class="clearfix"></div>
						</div>
					</div>
				</div>
			</div>
			<h3 ng-if="!packageManager.hasUpgradeablePackages()" class="light tcenter lh-12" style="margin: 5% 0"><i class="icon-ok-sign o-07 fs-2 d-inline-block m-025-bottom"></i><br/>Dropper und alle installierten Drops<br/>sind aktuell!</h3>
		</div>

		<!-- Show Forced Upgrades -->
		<div ng-if="overviewMode == 'forcedUpgrades'">
			<div ng-if="packageManager.hasForcedUpgrades()">
				<div class="clearfix p-1">
					<h4>Pflichtaktualisierungen verfügbar!</h4>
					<p class="o-07">Folgende Pakete sollten von dir aktualisiert werden, um weiterhin fehlerlos zu funktionieren:</p>
				</div>
				<hr class="m-0">
				<div class="drop-list list-style">
					<div class="drop" ng-repeat="(id, package) in packageManager.getForcedUpgrades()" ng-click="select(package, 'upgrade')">
						<span class="drop-image" style="background-image:url({{package.meta.icon}})"></span>
						<div class="name">{{package.meta.name}}<span class="badge badge-info pull-right">{{packageManager.getInstalledVersion(id)}} &raquo; {{package.candidate.version}}</span></div>
						<div class="desc">{{package.meta.description}}</div>
						<div class="clearfix"></div>
					</div>
				</div>
			</div>
			<h3 ng-if="!packageManager.hasForcedUpgrades()" class="light tcenter lh-12" style="margin: 5% 0"><i class="icon-ok-sign o-07 fs-2 d-inline-block m-025-bottom"></i><br/>Keine Pflichaktualisierungen vorhanden!</h3>
		</div>

		<!-- Show Installable Packages -->
		<div ng-if="overviewMode == 'store'">
			<div ng-if="packageManager.hasInstallablePackages()">
				<div ng-repeat="(type, typeName) in packageTypes" ng-show="utils.countObject(packageManager.getInstallable(type)) > 0">
					<div class="clearfix p-1">
						<h4 class="tleft">{{typeName}}</h4>
					</div>
					<hr class="m-0">
					<div class="drop-list list-style">
						<div class="drop" ng-repeat="(id, package) in packageManager.getInstallable(type) | filterObj:'meta.name':search.filter" ng-click="select(package, 'install')">
							<span class="drop-image" style="background-image:url({{package.meta.icon}})"></span>
							<div class="name">{{package.meta.name}}<span class="badge badge-info pull-right">{{package.candidate.version}}</span></div>
							<div class="desc">{{package.meta.description}}</div>
							<div class="clearfix"></div>
						</div>
					</div>
				</div>
			</div>
			<h3 ng-if="!packageManager.hasInstallablePackages()" class="light tcenter" style="margin: 5% 0">Nichts Neues verf&uuml;gbar</h3>
		</div>

		<!-- Show Installed Packages -->
		<div ng-if="overviewMode == 'installed'">
			<div ng-if="utils.countObject(core.templates) > 0">
				<!-- Drops -->
				<div class="clearfix p-1">
					<h4 class="tleft"><span ng-if="!search.filter">Installierte </span>Drops</h4>
				</div>
				<hr class="m-0">
				<div class="drop-list list-style">
					<div class="drop" ng-repeat="(id, template) in core.templates | filterObj:'name':search.filter" ng-click="select({'id' : id, 'meta' : template}, 'uninstall')">
						<span class="drop-image" ng-class="{'no-img' : !template._icon}" style="background-image:url({{template._icon}})"></span>
						<div class="name">{{template.name}}<span class="badge badge-info pull-right">{{template.version}}</span></div>
						<div class="desc">{{template.description}}</div>
						<div class="clearfix"></div>
					</div>
				</div>
				<!-- Integrations -->
				<div class="clearfix p-1">
					<h4 class="tleft"><span ng-if="!search.filter">Installierte </span>Template Integrationen</h4>
				</div>
				<hr class="m-0">
				<div class="drop-list list-style">
					<div class="drop" ng-repeat="(id, integration) in core.integrations | filterObj:'name':search.filter" ng-click="select({'id' : id, 'meta' : integration}, 'uninstall')">
						<span class="drop-image integration-image" ng-class="{'no-img' : !integration._icon}" style="background-image:url({{integration._icon}})"></span>
						<div class="name">{{integration.name}}<span class="badge badge-info pull-right">{{integration.version}}</span></div>
						<div class="desc">{{integration.description}}</div>
						<div class="clearfix"></div>
					</div>
				</div>
			</div>
			<h3 ng-if="!utils.countObject(core.templates)" class="light tcenter" style="margin: 5% 0">Keine Drops installiert</h3>
		</div>

		<!-- Show Holdback Packages -->
		<div ng-if="overviewMode == 'holdback'">
			<div class="clearfix p-1">
				<h4 class="pull-left">{{utils.countObject(packageManager.getHoldback())}} Drops nicht installierbar</h4>
			</div>
			<hr class="m-0">
			<div class="drop-list list-style">
				<div class="drop" ng-repeat="(id, package) in packageManager.getHoldback()">
					<span class="drop-image" style="background-image:url({{package.meta.icon}})"></span>
					<div class="name">{{package.meta.name}}</div>
					<div class="fs-09 o-07 m-1-top m-0-bottom">
						<li ng-repeat="(item, reason) in package.dependencyErrors"><strong>{{item}}</strong> {{reason}}</li>
					</div>
					<div class="clearfix"></div>
				</div>
			</div>
		</div>
		
	</div>
	<div class="modal-footer">
		<div class="pull-right">
			<div class="btn btn-primary" ng-click="close()">Schliessen</div>
		</div>
	</div>
</div>
<!-- Upgrade Mode -->
<div ng-if="mode === 'upgrade'">
	<div class="modal-header">
		<div class="close" ng-click="close()">×</div>
		<div class="tcenter">
			<h4 class="tcenter">{{selected.meta.name}} aktualisieren</h4>
			<p>&quot;{{selected.meta.name}}&quot; kann  automatisch für dich aktualisiert werden</p>
		</div>
	</div>
	<div class="modal-body">
		<table style="width: 100%">
			<tr>
				<td style="width: 34%">
					<img ng-src="{{selected.meta.icon}}" width="220" class="pull-left"/>
				</td>
				<td style="width: 66%">
					<table class="table table-bordered">
						<tr>
							<td>Update</td>
							<td><span title="Installierte Version">{{packageManager.getInstalledVersion(selected.id)}}</span> <span class="o-06">&raquo;</span> <span title="Neue Version">{{selected.candidate.version}}</span> <span class="fs-09 o-08" title="Update-Quelle (Repository)">({{getRepoInfo(selected)}})</span></td>
						</tr>
						<tr>
							<td>Changelog<small v-if="selected.candidate.changelog"><br>({{selected.candidate.version}})</small></td>
							<td>
								<div v-if="selected.candidate.changelog" class="fs-095 m-05-bottom" style="max-height: 130px; overflow: auto;">
									<div class="markdown" ng-bind-html-unsafe="selected.candidate.changelog"></div>
								</div>
								<hr v-if="selected.candidate.changelog" class="m-05-top m-05-bottom"/>
								<a href="{{selected.meta.changelog}}" class="btn btn-default btn-small" target="_blank"><i class="icon-external-link fs-095 o-08 m-025-right"></i> Kompletten Changelog ansehen</a>
							</td>
						</tr>
					</table>
					
				</td>
			</tr>
		</table>
		<p class="alert alert-info m-0-bottom">Es wird automatisch ein Backup der alten Dateien angelegt, falls etwas schief laufen sollte. Bitte lasse das Browserfenster offen, bis das Update erfolgt ist.</p>
	</div>
	
	<div class="modal-footer">
		<div class="pull-right">
			<div class="btn btn-primary" ng-click="takeAction('upgrade', selected)">Update starten</div>
			<div class="btn" ng-click="toOverview()">Abbrechen</div>
		</div>
	</div>
</div>

<!-- Installation Mode -->
<div ng-if="mode === 'install'">
	<div class="modal-header">
		<div class="close" ng-click="close()">×</div>
		<div class="tcenter">
			<h4 class="tcenter">{{selected.meta.name}} installieren</h4>
			<p>&quot;{{selected.meta.name}}&quot; kann  automatisch für dich installiert werden</p>
		</div>
	</div>
	<div class="modal-body">
		<table style="width: 100%">
			<tr>
				<td style="width: 35%">
					<img ng-src="{{selected.meta.icon}}" width="220" class="pull-left"/>
				</td>
				<td style="width: 65%">
					<table class="table table-bordered">
						<tr>
							<td>Beschreibung</td>
							<td>{{selected.meta.description}}</td>
						</tr>
						<tr>
							<td>Weitere&nbsp;Infos</td>
							<td><a class="btn btn-default btn-small" href="{{selected.meta.url}}" target="_blank"><i class="icon-external-link fs-095 o-08 m-025-right"></i> Online ansehen</a></td>
						</tr>
						<tr>
							<td>Version</td>
							<td>{{selected.candidate.version}} <span class="fs-09 o-08" title="Installations-Quelle (Repository)">({{getRepoInfo(selected)}})</span></td>
						</tr>
					</table>
					
				</td>
			</tr>
		</table>

		<p class="alert alert-info">Es wird automatisch ein Backup der alten Dateien angelegt, falls etwas schief laufen sollte. Bitte lasse das Browserfenster offen, bis das Upgrade erfolgt ist.</p>
	</div>
	
	<div class="modal-footer">
		<div class="pull-right">
			<div class="btn btn-primary" ng-click="takeAction('install', selected)">Installation starten</div>
			<div class="btn" ng-click="toOverview()">Abbrechen</div>
		</div>
	</div>
</div>
<!-- Uninstallation Mode -->
<div ng-if="mode === 'uninstall'">
	<div class="modal-header">
		<div class="close" ng-click="close()">×</div>
		<div class="tcenter">
			<h4 class="tcenter">{{selected.meta.name}} entfernen</h4>
			<p>&quot;{{selected.meta.name}}&quot; kann  automatisch für dich entfernt werden</p>
		</div>
	</div>
	<div class="modal-body">
		<table style="width: 100%">
			<tr>
				<td style="width: 35%">
					<img ng-src="{{selected.meta._icon}}" width="220" class="pull-left"/>
				</td>
				<td style="width: 65%">
					<table class="table table-bordered">
						<tr>
							<td>Beschreibung</td>
							<td>{{selected.meta.description}}</td>
						</tr>
						<tr>
							<td>Installiert</td>
							<td>{{selected.meta.version}}</td>
						</tr>
					</table>
					
				</td>
			</tr>
		</table>
		<p class="alert alert-danger" ng-if="dropInUse(selected.id)">Dieses Drop ist noch in Benutzung und kann daher nicht deinstalliert werden! Gehe vor der Deinstallation sicher, dass du keine Instanz des {{selected.meta.name}} Drops mehr nutzt oder benötigst.</p>
		<p class="alert alert-info" ng-if="!dropInUse(selected.id)">Wenn du dieses Drop entfernst, kannst du es nicht mehr nutzen. Aber keine Angst, du kannst es jederzeit aus der Paketverwaltung heraus neu installieren!</p>
	</div>
	
	<div class="modal-footer">
		<div class="pull-right">
			<div class="btn btn-danger" ng-click="takeAction('uninstall', selected)" ng-if="!dropInUse(selected.id)">{{selected.meta.name}} entfernen</div>
			<div class="btn" ng-click="toOverview()">Abbrechen</div>
		</div>
	</div>
</div>
<!-- Progress Mode -->
<div ng-if="mode === 'progress'">
	<div class="modal-header">
		<div class="close" ng-if="!working" ng-click="close()">×</div>
		<div class="tcenter">
			<h4 class="tcenter">{{getProgressTitle(action, selected)}}</h4>
			<p>Bitte lasse das Browserfenster offen, bis der Vorgang abgeschossen ist.</p>
		</div>
	</div>
	<div class="modal-body">
		<div class="progress" ng-class="{'active progress-striped': working}">
			<div class="bar" ng-class="{'bar-danger':log.status != 200 && !working, 'bar-success':log.status == 200}" style="width: 100%;"></div>
		</div>

		<div class="alert alert-error" ng-if="!working && log && log.status !== 200">
			Oups, der Vorgang ist leider fehlgeschlagen! Schaue auf die Logs um mehr Informationen zu den Fehlern zu erhalten.
		</div>

		<div class="alert alert-success" ng-if="!working && log && log.status == 200">
			Yippie, der Vorgang wurde erfolgreich abgeschlossen!
		</div>

		<hr/>

		<ul class="nav nav-tabs nav-stacked">
			<li class="active" ng-repeat="logItem in log.log">
				<a>
					<p><span class="badge badge-{{getStatusClass(logItem.status)}}">{{logItem.status}}</span>&nbsp;&nbsp;<small>{{logItem.date}}</small></p>
					<pre style="font-size: 12px; line-height: 15px" ng-if="log"><code>{{logItem.log}}</code></pre>
				</a>
			</li>
		</ul>
	</div>
	
	<div class="modal-footer">
		<div class="pull-right">
			<div class="btn" ng-if="!working" ng-click="toOverview()">Zur &Uuml;bersicht</div>
			<div class="btn btn-primary" ng-if="!working" ng-click="close()">Schliessen</div>
		</div>
	</div>
</div>
