<div class="kk-product-filter well m-0 relative" ng-class="{'kk-product-filter-loading': isLoading()}">

	<!-- head -->
	<div class="kk-product-filter-head">

		<!-- filter description -->
		<div class="kk-product-filter-desc" ng-if="!controlState.error">
			<span ng-bind-html="trustHtml(getFilterDescription())"></span>
			<i ng-if="isLoading()" class="spinner o-06 m-05-left"></i>
			<span ng-if="!isLoading()">
				<span ng-if="!kkOption.hideResultNumbers && kkOption.purpose !== 'link'">({{filters.count}}&nbsp;Produkte)</span>
				<span ng-if="kkOption.purpose === 'link' && getFilterUrl()">(<a title="{{filters.title}}" href="{{filters.url}}" target="_blank">{{getFilterUrl()}}</a>)</span>
			</span>
		</div>

		<!-- error output -->
		<div class="kk-product-filter-desc" ng-if="controlState.error"><span class="text-danger"><i class="icon-bolt m-05-right"></i>Fehler beim Laden des Controls!</span></div>

		<!-- config buttons -->
		<div class="btn-group" style="position: absolute; top: -1px; right: -1px">
			<div class="btn" style="border-top-left-radius:0" kk-tooltip="Filter Einstellungen" ng-if="kkOption.purpose !== 'link'"
				ng-class="{active: controlState.showSettings}" ng-click="controlState.showSettings=!controlState.showSettings">
				<i class="icon-gear"></i></div>
			<div class="btn" ng-class="{disabled: !filters.active.length}"
				style="border-bottom-right-radius:0; border-top-right-radius:4px; border-top-left-radius: 0;"
				kk-tooltip="Alle zurücksetzen" ng-click="resetAll()"><i class="icon-trash"></i></div>
		</div>

	</div>

	<div class="kk-product-filter-body">
		
		<!-- error state -->
		<pre ng-if="controlState.error" style="max-height: 200px; overflow-y: auto" class="fs-08 m-0 kk-product-filter-param p-1">{{controlState.error}}</pre>

		<!-- normal entries -->
		<div class="kk-product-filter-param" ng-repeat="param in activeParams" ng-if="!controlState.showSettings">
			<div class="kk-product-filter-param-head" ng-click="toggleParamTab(param)">
				<h4 style="flex-shrink: 0"><i ng-if="getDefForParam(param).filter" class="icon-filter o-06 m-05-right"></i><i ng-if="getDefForParam(param).entry" class="icon-location-arrow o-06 m-025-right"></i>{{getDefForParam(param).label}}</h4>
				<h4 class="kk-product-filter-selected-values m-1-right o-08" ng-if="getSelectedValuesForParam(param).length">&nbsp;&bull;&nbsp;<span ng-repeat="value in getSelectedValuesForParam(param)"><span ng-if="value.item" ng-bind-html="trustHtml(value.item.name)"></span><span ng-if="!value.item">NOT FOUND</span><span ng-if="!$last">, </span></span></h4>
				<i class="icon-trash remove-param btn btn-mini btn-transparent no-bg" kk-tooltip="Entfernen" ng-click="resetConfigParam(param)"></i>
				<i ng-class="{'icon-angle-down': isParamTabActive(param), 'icon-angle-right': !isParamTabActive(param)}" class="o-05 m-1-left" style="width: 1em; text-align: center;"></i>
			</div>
			<div class="kk-product-filter-param-body" ng-show="isParamTabActive(param)">
				<kk-propertygrid kk-model="kkModel.params" kk-config="getSettingsForParam(param)"></kk-propertygrid>
				<div class="kk-product-filter-options" ng-if="getOptionsForParam(param).options.length">
					<a class="kk-product-filter-option" ng-repeat="option in getOptionsForParam(param).options" href="javascript:void(0)"
						ng-click="addParamOption(param, option)">
						<span ng-bind-html="trustHtml(option.name)"></span><span ng-if="!kkOption.hideResultNumbers">&nbsp;({{option.filterCount}})</span>
					</a>
				</div>
			</div>
		</div>

		<!-- adders -->
		<div class="kk-product-filter-param kk-product-filter-param-adder m-0" ng-class="{'no-bg': activeParams.length}" ng-class="{'m-2-top': activeParams.length}" ng-if="!controlState.showSettings && (getPossibleEntries().length || getPossibleFilters().length)">
			<div class="kk-product-filter-param-body">
				<div class="kk-product-filter-adders-wrap" ng-if="getPossibleEntries().length">
					<label class="control-label d-block m-1-bottom"><i class="icon-location-arrow o-06 m-05-right"></i>Einstieg hinzufügen</label>
					<div class="kk-product-filter-adders">
						<div class="kk-product-filter-add" ng-repeat="def in getPossibleEntries()" ng-click="addConfigParam(def.param)">{{def.label}}</div>
					</div>
				</div>
				<div class="kk-product-filter-adders-wrap" ng-if="getPossibleFilters().length">
					<label class="control-label d-block m-1-bottom"><i class="icon-filter o-06 m-05-right"></i>Filter hinzufügen</label>
					<div class="kk-product-filter-adders">
						<div class="kk-product-filter-add" ng-repeat="def in getPossibleFilters()" ng-click="addConfigParam(def.param)">{{def.label}}&nbsp;<span class="o-06" ng-if="!kkOption.hideResultNumbers && getOptionsForParam(def.param).total > 0">({{getOptionsForParam(def.param).total}})</span></div>
					</div>
				</div>
			</div>
		</div>

		<!-- settings -->
		<div class="kk-product-filter-param m-0" ng-if="controlState.showSettings">
			<div class="kk-product-filter-param-head"><h4><i class="icon-gear o-06 m-05-right"></i>Einstellungen</h4></div>
			<div class="kk-product-filter-param-body">
				<kk-propertygrid kk-model="kkModel" kk-config="settingsConfig"></kk-propertygrid>
			</div>
		</div>

	</div>

</div>