<!-- Drop Informations -->
<div class="dropInfoModal">
	<span ng-class="{'no-img': !core.templates[dropInfo.dropId]._icon}" class="drop-image" style="background-image:url({{core.templates[dropInfo.dropId]._icon}})"/></span>
	<div class="modal-header">
		<div class="close" ng-click="close()">×</div>
		<h4>{{dropInfo.name}}</h4>

		<div class="btn-group">
			<span class="btn btn-small" ng-class="{'active': dropInfo.tab == 'infos'}" ng-click="dropInfo.tab='infos'">Infos</span>
			<span class="btn btn-small" ng-show="dropInfo.faq && dropInfo.faq.length > 0" ng-class="{'active': dropInfo.tab == 'faq'}" ng-click="dropInfo.tab='faq'">FAQ</span>
			<span class="btn btn-small" ng-class="{'active': dropInfo.tab == 'licence'}" ng-click="dropInfo.tab='licence'">Lizenz</span>
			<span class="btn btn-small" ng-if="core.packages.upgradeable[dropInfo.dropId]" ng-click="showUpdateManager(dropInfo.dropId)">Update</span>
		</div>
	</div>
	<div class="modal-body">

		<!-- Drop Information -->
		<div class="markdown" ng-show="dropInfo.tab=='infos'" ng-bind-html-unsafe="dropInfo.description">
		</div>

		<!-- Drop FAQ -->
		<div class="markdown" ng-show="dropInfo.tab=='faq'" ng-bind-html-unsafe="dropInfo.faq"></div>

		<!-- Drop Licence Info -->
		<div class="licencing" ng-show="dropInfo.tab=='licence'">
			<h1>Lizenzierung</h1>
			<p class="alert alert-warning" ng-if="!core.templates[dropInfo.dropId]">
				<strong>Fehler:</strong> {{dropInfo.dropId}} ist nicht installiert, wurde modifiziert oder konnte nicht gefunden werden!
			</p>
			<div ng-if="core.templates[dropInfo.dropId]">
				<p class="alert alert-warning" ng-if="!core.dropLicenses[dropInfo.dropId].isValid">
					<strong>Drop inaktiv - </strong> {{core.dropLicenses[dropInfo.dropId].reason}}
				</p>
				<p class="alert alert-success" ng-if="core.dropLicenses[dropInfo.dropId].isValid">
					<i class="icon-time" ng-if="core.dropLicenses[dropInfo.dropId].canExpire"></i> 
					<strong>Aktiv - </strong> {{core.dropLicenses[dropInfo.dropId].reason}}
				</p>
			</div>
		</div>
	</div>
	<div class="modal-footer">
		<div class="btn btn-primary right" ng-if="utils.Drops.canAddDrop(dropInfo.dropId)" ng-click="utils.Drops.addDrop(dropInfo.dropId, true)" data-dismiss="modal">
			<i class="icon-plus icon-white"></i> Neues {{dropInfo.name}} Drop
		</div>
		<a ng-if="core.templates[dropInfo.dropId] && !core.dropLicenses[dropInfo.dropId].hasLicense && !core.dropLicenses[dropInfo.dropId].isValid" href="{{getLicenseUrl(dropInfo.dropId, 'test')}}" class="btn btn-primary right" target="_blank"><i class="icon-time"></i> Testlizenz erstellen</a>
		<a ng-if="core.templates[dropInfo.dropId] && (!core.dropLicenses[dropInfo.dropId].isValid || core.dropLicenses[dropInfo.dropId].isDemo)" href="{{getLicenseUrl(dropInfo.dropId, 'buy')}}" class="btn btn-primary right" target="_blank"><i class="icon-shopping-cart"></i> Lizenz kaufen</a>
	</div>
</div>