<div class="sidebar-wrapper">
	<div class="sidebar flex-vertical">
		<div class="head">
			<div class="head-search" ng-show="!editMode">
				<!-- search input -->
				<input class="search" required ng-class="{loading: groupState.searchLoading}" type="text" ng-model="search" ng-model-options="{updateOn: 'change blur', debounce: { change: 0, blur: 0 }}" placeholder="Drop suchen"></input>
				<!-- Forward / Back navigation -->
				<kk-history-switcher></kk-history-switcher>
			</div>
			<!-- sort mode info -->
			<h5 class="m-0" ng-show="editMode"><i class="icon-info-sign"></i> Drag'n'Drop um die Reihenfolge zu &auml;ndern</h5>
		</div>
		<div class="scroll-y flex-fill" ng-if="!editMode">

			<!-- sidebar tree -->
			<kk-sidebar-group ng-if="tree" group="tree" group-state="groupState" parent="null"></kk-sidebar-group>

			<!-- no search results -->
			<div class="no-content" ng-if="core.settings.drops.length && !tree.count">
				<h2>Keine Ergebnisse</h2>
				<p>Leider konnte zu deiner Suche nichts gefunden werden.</p>
			</div>

			<!-- no drops yet -->
			<div class="no-content" ng-if="core.settings.drops.length == 0">
				<i class="icon-plus-sign" ng-click="utils.Drops.getNewDropUserSelect()"></i><br/>
				<h2>Du hast noch keine Drops erstellt</h2>
				<p>Schau im Dashboard nach installierten Drops. Von dort aus kannst du jederzeit neue Inhalte erstellen.</p>
			</div>
		</div>
		<!-- sort mode -->
		<div class="scroll-y flex-fill" ng-if="editMode">
			<div class="group-drops drop-sorter" ui-sortable ng-model="core.settings.drops">
				<div ng-repeat="drop in core.settings.drops" class="group-drop group-item sort-item">
					<div><small>{{$index+1}}.&nbsp;</small></div>
					<div class="drop-label">{{::utils.Drops.ungroupLabel(drop._internal.name)}}</div>
					<div class="item-type" title="{{::utils.Drops.groupLabel(drop._internal.name)}}">{{::utils.Drops.groupLabel(drop._internal.name)}}&nbsp;&nbsp;&nbsp;<i class="icon-remove-sign fadebtn" ng-click="groupState.tryDropRemove(drop, $event)"></i></div>
				</div>
			</div>
		</div>
		<div class="foot">
			<!-- new drop draggable placeholder -->
			<div class="new-drop" kk-drop-draggable ng-click="selectAndAddDrop()">
				<i class="icon-plus-sign"></i><span class="new-drop-label">Neues Drop</span>
			</div>
			<div class="btn-group">
				<span class="btn" kk-tooltip="Drops sortieren/löschen" ng-class="{'active': editMode==true}" ng-click="editMode=!editMode"><i class="icon-list"></i></span>
			</div>
		</div>

	</div>
	<div class="sidebar-handle"></div>

	<!-- drop remove popover -->
	<div class="remove-popup popover fade bottom">
		<div class="arrow"></div>
		<div class="popover-inner">
			<h3 class="popover-title">Löschen</h3>
			<div class="popover-content">
				<small><strong>{{groupState.dropToRemove._internal.name}}</strong> wirklich löschen?</small><hr/>
				<div class="btn btn-small btn-danger" ng-click="removeDrop()">Entfernen</div>
				<div class="btn btn-small pull-right" ng-click="cancelDropRemove()">Abbrechen</div>
			</div>
		</div>
	</div>

</div>
